/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBModuleGallery = Object.create(STBModule.prototype);

STBModuleGallery.name = "ModuleGallery";
STBModuleGallery.initPlugin = function() {

	var el=$(".gallery-ajax:not(.__done)");

	if (el.length) {
		el.each(function() {
		
			var item = $(this);

			item.click(function(e) {
				e.preventDefault();			

				var images = $.getJSON(
					item.attr("data-json"), 
					function(msg) {
						if (msg.length > 0)	{
							item.lightGallery({
								dynamic: true,
								dynamicEl: msg
							});
						}
					}
				);
			});


			

			$(this).addClass("__done");
		});	
	}
}

STBModuleGallery.runOnReady = function() {
	STBModuleGallery.initPlugin();
}

STBModuleGallery.runOnContentUpdate = function() {
	STBModuleGallery.initPlugin();
}

site.registerModule(STBModuleGallery);